% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DA_AllEE5_inside.R
\name{DA_AllEE5_inside}
\alias{DA_AllEE5_inside}
\title{Internal calculation of estimating equation for DA_AllEE5}
\usage{
DA_AllEE5_inside(beta, CASEZ_1, CASEZ_2, CASEZhat_1, CASEZhat_2, CASEZhat_22,
  CONTZ_1, CONTZ_2, CONTZhat_1, CONTZhat_2, CONTZhat_22, prob_case_1,
  prob_case_11, prob_case_2, prob_case_22, prob_cont_1, prob_cont_2, p,
  pi_case_1, pi_case_1_t, pi_case_2, pi_case_2_t, pi_cont_1, pi_cont_1_t,
  pi_cont_2, Z_case_pi_1, Z_case_pi_1_t, Z_case_pi_2, Z_case_pi_2_t,
  Z_cont_pi_1, Z_cont_pi_1_t, Z_cont_pi_2, J_step3, V_step3, pwt_cont_2,
  subset_2, subset_3, subset_4)
}
\arguments{
\item{beta}{Parameter \eqn{\beta}.}

\item{CASEZ_1, CASEZhat_1}{case data(N1) from case-control study,
details please see definition in the help of realdata_covariates.}

\item{CASEZ_2, CASEZhat_2, CASEZhat_22}{CTR data(N2), details please see definition in the help of realdata_covariates.}

\item{CONTZ_1, CONTZhat_1}{control data(M1) from case-control study, details please
see definition in the help of realdata_covariates.}

\item{CONTZ_2, CONTZhat_2, CONTZhat_22}{BRFSS data(M2), details please see definition in the help of realdata_covariates.}

\item{prob_cont_1, prob_cont_2, prob_case_1, prob_case_11, prob_case_2, prob_case_22, pwt_cont_2}{please see definition in the help of realdata_alpha.}

\item{p}{Number of parameters, a constant value of 8.}

\item{pi_case_1, pi_case_1_t, pi_case_2, pi_case_2_t, pi_cont_1, pi_cont_1_t, pi_cont_2}{selection bias}

\item{Z_case_pi_1, Z_case_pi_1_t, Z_case_pi_2, Z_case_pi_2_t, Z_cont_pi_1, Z_cont_pi_1_t, Z_cont_pi_2}{part
of variables from covariates, used for the estiamtion of variance.}

\item{J_step3}{Derivative of the estimating equation.}

\item{V_step3}{Variance of the estimating equation.}

\item{subset_2}{A vector of 1:(p-2).}

\item{subset_3}{A vector of 1:p.}

\item{subset_4}{A vector of 1:(p-2).}
}
\value{
A list of (f,J,V)
\enumerate{
\item f The final form of the estimating equation after adjusting eta.
\item J_step3 The derivative of the estimating equation.
\item V_step3 The variance of the estimating equation.
}
}
\description{
This is the internal function to solve the estimating equation constructed by
pair (N1,M1), (N1,M2), (N2,M1) and (N2,M2) with selection bias probility \eqn{\pi(s,\eta)}
included. Since it's a internal function for function DA_AllEE5, thus it's not a necessary
or important function.
}
\details{
The function solves estimating equation based on GMM combined estimating equations
with handling selection bias.
It also accounts for the uncertainty due to the estimated value of eta. The function will
output the estimating equation at current input value beta. Hence it can be used in "nleqslv" to solve for
\eqn{\beta}. Because the function also outputs J and V, the asymptotic variance of \eqn{\beta}
can be calculated in a straightforward way. \eqn{\hat{Z}_l} may be highly correlated with Z_d, so it is
removed in the estimation. And it has to be careful in constructing f, J and V.
}

