% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PremierL.R
\docType{data}
\name{PremierL}
\alias{PremierL}
\title{Premier league results}
\format{
A data frame with 208 rows (games) and 6 columns:
\describe{
  \item{Date}{The data of the game}
  \item{HomeTeam}{The name of the home team; for example \code{Liverpool} or \code{Man United}}
  \item{AwayTeam}{The name of the away team; for example \code{Wolves} or \code{West Ham}}
  \item{HomeGoals}{The number of goals scored by the home team}
  \item{AwayGoals}{The number of goals scored by the away team}
  \item{Result}{The result, one of \code{H} for the home team, \code{A} for the away team, or \code{D} for a draw}
}
}
\source{
The website https://sports-statistics.com/sports-data/soccer-datasets/
}
\usage{
data(PremierL)
}
\description{
Premier League football (soccer) results from 2019 to 2020.
}
\examples{
plot(AwayGoals ~ factor(Result), data = PremierL, xlab = "Winning team", ylab = "Away goals")
}
\keyword{datasets}
