% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directly_calcSRscore.R
\name{directly_calcSRscore}
\alias{directly_calcSRscore}
\title{Aggregate the results of the three functions into a single list}
\usage{
directly_calcSRscore(
  .data1,
  grp,
  var1,
  var2,
  .data2,
  is.log2 = NA,
  threshold = c(-1, 1)
)
}
\arguments{
\item{.data1}{A data frame containing the two variables you want to compare, as well as the variables of the group to which they belong.}

\item{grp}{Column name of groups.}

\item{var1}{Column name of first variable.}

\item{var2}{Column name of second variable.}

\item{.data2}{A data frame containing expression values for a series of arrays, with rows corresponding to genes and columns to samples.}

\item{is.log2}{A logical specifying if .data2 is log-2transformed.}

\item{threshold}{A vector of length 2 (x, y) indicating threshold values. \code{c(-1, 1)} is default.}
}
\value{
A data frame containing results.
}
\description{
The SRscore calculation process is divided into three major processes, and functions are provided for each process (see the respective function documents for details).
\code{directly_calcSRscore()} aggregates the results of the three functions into a single list.
}
\examples{
grp <- "Series"
var1 <- "control_sample"
var2 <- "treated_sample"

ls <- directly_calcSRscore(MetadataABA,
                           grp,
                           var1,
                           var2,
                           TranscriptomeABA,
                           is.log2 = TRUE,
                           threshold = c(-1, 1))
lapply(ls, head)

}
\seealso{
\code{\link[=expand_by_group]{expand_by_group()}}

\code{\link[=calcSRratio]{calcSRratio()}}

\code{\link[=calcSRscore]{calcSRscore()}}
}
