% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_SSM.R
\name{construct.K}
\alias{construct.K}
\title{Construct the K matrix for a given multivariate basis.}
\usage{
construct.K(basis)
}
\arguments{
\item{basis}{A matrix.  Rows of the matrix are taken as the exponent vectors
of the leading terms of a Legendre polynomial basis.}
}
\value{
A matrix where each entry is \eqn{<f, g>} with \deqn{<f, g> = \int_X
 \sum_{i,j}\frac{d^2f}{dx_idx_j}\frac{d^2g}{dx_idx_j} dx,} with \eqn{f, g}
 being the Legendre polynomials described by the appropriate exponent vectors.
}
\description{
This function constructs the K matrix for a given multivariate basis assuming
the basis is a Legendre polynomial basis and the smoothing criterion is the
Frobenius norm of the Hessian integrated over \eqn{[-1, 1]^d}.
}
\keyword{internal}

