% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_SSM.R
\name{find.theta}
\alias{find.theta}
\title{Compute the SSM vector of parameters.}
\usage{
find.theta(response, K, design_model, tol = .Machine$double.eps)
}
\arguments{
\item{response}{An length \eqn{n} vector. The observed responses.}

\item{K}{A semi-positive definite \eqn{N x N} matrix that defines the smoothing
criterion.}

\item{design_model}{The \eqn{n x N} design model matrix.}

\item{tol}{(optional) The model fitting requires the inversion of a large
matrix and if the model basis is too large there can be numerical issues.
This argument is passed on to \code{\link{solve}} so models can be fit
despite these issues.}
}
\value{
A vector of parameters of length \eqn{N} if the model is fit
 successfully. \code{NA} is returned should \code{\link{solve}} not invert
 the required matrix.
}
\description{
This function is called by \code{\link{fit.ssm}} to compute the coefficient
vector that interpolates the data and minimises the smoothness of the
resulting model.
}
\keyword{internal}

