% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_SSM.R
\name{predict.SSM}
\alias{predict.SSM}
\title{Point prediction of smooth supersaturated models.}
\usage{
\method{predict}{SSM}(object, x, alpha = 0.05, ...)
}
\arguments{
\item{object}{An SSM object.}

\item{x}{A \eqn{d} length vector identifying the prediction point.}

\item{alpha}{(optional) A number in \eqn{[0, 1]} for the \eqn{(1 - \alpha)}
metamodel error estimate credible interval. Set to \code{0.05} by default.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
Either a number if the SSM has no metamodel error estimating Gaussian
process, or three numbers giving the model prediction (\code{$model}), and
the lower and upper bounds of the credible interval (\code{$lower} and
\code{$upper}) respectively.
}
\description{
This method gives the prediction of an SSM object at a point. If the
SSM has a metamodel error estimate then a \eqn{(1 - \alpha)} credible
interval is also output.
}
\examples{
data(attitude)
X <- transform11(attitude[ 2:7])
Y <- attitude[ , 1]
# with no metamodel error estimating GP.
s <- fit.ssm(X, Y)
predict(s, rep(1,6))

# with metamodel error estimating GP.
s <- fit.ssm(X, Y, GP = TRUE)
predict(s, rep(1,6))
}

