% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdmx_table.R
\name{sdmx_table}
\alias{sdmx_table}
\title{Import data from SDMX}
\usage{
sdmx_table(file)
}
\arguments{
\item{file}{a "sdmx archive" file that was downloaded from STATcube.}
}
\value{
An object of class \code{sc_data}
}
\description{
Function that reads STATcube data from an sdmx archive - a zip file
consisting of \code{structure.xml} with metadata and \code{dataset.xml} for the
values.
}
\note{
\code{\link[=sdmx_table]{sdmx_table()}} should be treated as experimental for now.
}
\examples{
x <- sdmx_table(system.file("sdmx/dedemo.zip", package = "STATcubeR"))
# print and tabulate
x
x$tabulate()
# explore hierarchies
nuts2 <- x$field("C-B00-0")
data.frame(label = nuts2$label,
  parent = nuts2$label[match(nuts2$parent, nuts2$code)])
# extract more data from the raw xml
xml2::xml_find_first(x$xml$meta, ".//Name")
}
\keyword{internal}
