% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stb.R
\name{fastSTB}
\alias{fastSTB}
\title{Simultaneous Tolerance Bands Using a Fast C-Implementation.}
\usage{
fastSTB(
  mat,
  alpha = 0.05,
  tol = 1e-04,
  max.iter = 100L,
  Ncpu = 2,
  timer = FALSE
)
}
\arguments{
\item{mat}{(numeric) matrix with rows representing simulations of 'ncol' values, rows are supposed to be sorted}

\item{alpha}{(numeric) 100(1-alpha)\% simultaneous tolerance level (coverage)}

\item{tol}{(numeric) convergence tolerance level for the bisection algorithm}

\item{max.iter}{(integer) number of bisection-steps for the algorithm}

\item{Ncpu}{(integer) specifying the number of processors (CPUs, cores, ...) to be used}

\item{timer}{(logical) TRUE = the time spent for computing the STB will be printed}
}
\value{
(list) with elements:
\item{mat}{(numeric) matrix with sorted random vector stored in rows}
\item{nCol}{(integer) number of columns of 'mat'}
\item{nRow}{(integer) number of rows of 'mat'}
\item{alpha}{(numeric) values used for the 100(1-alpha)\% STB}
\item{tol}{(numeric) the tolerance value used as stopping criterion for the bisection algorithm}
\item{max.iter}{(integer) the max. number of iteration of the bisection algorithm}
\item{Q}{(numeric) matrix with 2 rows, corresponding to the bounds of the STB (1st row = lower bounds, 2nd row = upper bounds)}
\item{coverage}{(numeric) value corresponding to the actual coverage of the STB}
}
\description{
This function represents the interface to a C-implementation of the bisection algorithm for computing
simultaneous tolerance bounds as described in Schuetzenmeister et al. 2012.
}
\details{
Quantiles will be computed according to SAS PCTLDEF5 definition of quantiles, which is identical to 'type=2' 
in function \code{\link{quantile}}. This is also the default-option throughout this package. Function \code{\link{SASquantile}}
is a R-implementation identical to the C-implementation used here.
}
\examples{
\dontrun{
### example for 10000 x 30 matrix
 set.seed(333)
 mat <- t(apply(matrix(rnorm(10000*30), ncol=30), 1, sort))
 stb.obj1 <- fastSTB(mat, timer=TRUE)
 stb.obj1$coverage
	stb.obj2 <- fastSTB(mat, timer=TRUE, Ncpu=4)
 stb.obj3 <- fastSTB(mat, timer=TRUE, Ncpu=6)
 stb.obj4 <- fastSTB(mat, timer=TRUE, Ncpu=8)
}
}
\references{
Schuetzenmeister, A., Jensen, U., Piepho, H.P. (2011), Checking assumptions of normality and homoscedasticity in the general linear model. 
            Communications in Statistics - Simulation and Computation; S. 141-154
}
\seealso{
\link{getSTB} \link{stb}
}
\author{
Andre Schuetzenmeister \email{andre.schuetzenmeister@roche.com}
}
