% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation_analysis.R
\name{calculate_correlations}
\alias{calculate_correlations}
\title{Perform correlation analysis between spatial features and distance metrics with visualization}
\usage{
calculate_correlations(
  spatial_data,
  distance_results,
  spatial_feature,
  distance_metric,
  method = "pearson",
  plot = TRUE,
  plot_title = NULL
)
}
\arguments{
\item{spatial_data}{Spatial data containing feature columns and Newbarcode identifier}

\item{distance_results}{Distance results containing distance metrics and Newbarcode identifier}

\item{spatial_feature}{Column name from spatial_data to use for correlation (e.g., "gen2_SPLIz_numeric")}

\item{distance_metric}{Column name from distance_results to use for correlation (e.g., "Epithelial_cells_A")}

\item{method}{Correlation method ("pearson", "spearman", "kendall")}

\item{plot}{Logical, whether to generate a scatter plot}

\item{plot_title}{Title for the scatter plot (optional)}
}
\value{
A list containing correlation results and ggplot object (if plot=TRUE)
}
\description{
Perform correlation analysis between spatial features and distance metrics with visualization
}
\examples{
calculate_correlations(spatial_data = posi,
             distance_results = distance_results,
             spatial_feature = "gen2_SPLIz_numeric",
             distance_metric = "Epithelial_cells_A",
             method = "pearson",
             plot = TRUE,
             plot_title = "Correlation between Gene Expression and Distance")
}
