% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classify_wetdry.R
\name{classify_wetdry}
\alias{classify_wetdry}
\title{classify_wetdry}
\usage{
classify_wetdry(stic_data, classify_var, threshold, method)
}
\arguments{
\item{stic_data}{A data frame with STIC data, such as that produced by \link{apply_calibration} or \link{tidy_hobo_data}.}

\item{classify_var}{Name of the column in data frame you want to use for classification. When \code{method} is \code{"y-intercept"}, this should be \code{condUncal}.}

\item{threshold}{This is the user-defined threshold for determining wet versus dry based on the designated classification variable. If using the \code{"absolute"} method, the threshold will be a value in the same units as the designated classification variable. If using the \code{"percent"} method, the value will be a decimal percentage (range 0-1) of the max value of the classification variable in the data frame. Values above this proportion of the maximum will be designated as wet. If using the \code{"y-intercept"} method, this should be a model fit used to generate calibrated \code{SpC} values such as that produced by \link{get_calibration}.}

\item{method}{User chooses which classification method used to generate the binary data. \code{"absolute"} uses an absolute numerical threshold for classifying wet vs dry. \code{"percent"} uses a threshold based on a given percentage of the maximum value of the classification variable in the data frame. \code{"y-intercept"} uses the y-intercept from the \link{get_calibration} function.}
}
\value{
The same data frame as input, but with a new column called \code{"wetdry"}.
}
\description{
This is a function to classify STIC data into a binary "wet" and "dry" column. Data can be classified according to any classification variable defined by the user. User can choose one of two methods for classification: either an absolute numerical threshold or as a chosen percentage of the maximum value of the classification variable.
}
\examples{
classified_df <-
  classify_wetdry(calibrated_stic_data,
    classify_var = "SpC", method = "absolute", threshold = 200
  )
head(classified_df)
}
