% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qx.R
\name{qx}
\alias{qx}
\title{Generate 1qx or 5qx age schedule of mortality from child or child/adult mortality}
\usage{
qx(
  sex,
  cm,
  smooth = TRUE,
  outlogit = FALSE,
  out5 = TRUE,
  am = NULL,
  modsv = 2024
)
}
\arguments{
\item{sex}{Character: 'female' or 'male'.}

\item{cm}{Decimal: the input value(s) for 5q0; either a single value or a vector of values.}

\item{smooth}{Boolean: use either smooth or raw SVD-derived components. Default is TRUE.}

\item{outlogit}{Boolean: output either logit-scale or natural-scale nqx values. Default is FALSE. When TRUE oldest age not returned because logit(1) not defined.}

\item{out5}{Boolean: output either 5-year or 1-year age groups. Default is TRUE.}

\item{am}{Optional decimal: input value(s) for 45q15; either single value or vector of values. If a vector, must have the same number of elements as cm.}

\item{modsv}{Optional integer: specifies version of calibration models to use: 2018, 2022, or 2024. Defaults is 2024.}
}
\value{
Data frame: generated 1qx or 5qx values. Oldest age assumed to be 1.0. Columns labeled with input child mortality values.
}
\description{
Generate single-year 1qx or 5-year 5qx age-specific probabilities of dying using the SVD-Comp mortality model indexed by child mortality, 5q0, or child and adult mortality, 5q0 and 45q15.
}
\examples{
qx("female",0.05)
qx("female",0.05,modsv=2022)
qx("male",0.03,am=0.26)
qx("male",0.03,TRUE,TRUE,TRUE,0.26)
qx("male",c(0.03,0.01))
}
\references{
Clark (2016) \doi{doi:10.48550/arXiv.1612.01408} and Clark (2019) \doi{doi:10.1007/s13524-019-00785-3}
}
\author{
Samuel J. Clark, \email{work@samclark.net}
}
