% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_stats.R
\name{ACAT_combine}
\alias{ACAT_combine}
\title{ACAT: Aggregated Cauchy Association Test}
\usage{
ACAT_combine(pvals, weights = NULL)
}
\arguments{
\item{pvals}{Numeric vector of p-values to combine.}

\item{weights}{Numeric vector of weights. If NULL (default), equal weights are used.}
}
\value{
A single combined p-value.
}
\description{
Combines multiple p-values using the Aggregated Cauchy Association Test (ACAT).
This method is robust and maintains correct type I error even with correlated
p-values.
}
\details{
ACAT transforms p-values using the Cauchy distribution and combines them:
\deqn{T = \sum_i w_i \tan(\pi(0.5 - p_i))}

The combined p-value is then computed from the Cauchy distribution.

This method has several advantages:
\itemize{
  \item Valid even when p-values are correlated
  \item Computationally simple
  \item Handles edge cases (p = 0 or 1) gracefully
}
}
\examples{
# Combine independent p-values
pvals <- c(0.01, 0.05, 0.3)
combined_p <- ACAT_combine(pvals)
print(combined_p)

}
\references{
Liu, Y. et al. (2019) ACAT: A Fast and Powerful P Value Combination Method
for Rare-Variant Analysis in Sequencing Studies. The American Journal of
Human Genetics.
}
