% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\name{merge.SWIMw}
\alias{merge.SWIMw}
\title{Merging Two Stressed Models}
\usage{
\method{merge}{SWIMw}(x, y, ...)
}
\arguments{
\item{x, y}{Objects of class \code{SWIMw}.}

\item{...}{Additional arguments will be ignored.}
}
\value{
A \code{SWIMw} object containing:
    \itemize{
      \item \code{x}, a data.frame containing the data;
      \item \code{h}, bandwidths;
      \item \code{u}, vector containing the gridspace on [0, 1]
      \item \code{lam}, vector containing the lambda's of the optimized model
      \item \code{str_fY}, function defining the densities of the stressed component;
      \item \code{str_FY}, function defining the distribution of the stressed component;
      \item \code{str_FY_inv}, function defining the quantiles of the stressed component;
      \item \code{gamma}, function defining the risk measure;
      \item \code{new_weights}, a list of functions, that applied to
  the \code{k}th column of \code{x}, generates the vectors of scenario
  weights. Each component corresponds to a different stress;
     \item \code{type}, specifies the stress type
     \item \code{specs}, a list, each component corresponds to
   a different stress and contains a list with the specifications
  of what has been stressed.
    }
    See \code{\link{SWIM}} for details.
}
\description{
This function is a \code{method} for an object of class 
    \code{SWIMw}.
}
\details{
Merges two objects of class \code{SWIMw}, that 
    are based on the same data. \cr
}
\author{
Zhuomin Mao
}
