% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_MUSIC.R
\name{seasonder_defaultMUSICOptions}
\alias{seasonder_defaultMUSICOptions}
\alias{seasonder_defaultMUSIC_options}
\title{Default Options for the MUSIC Algorithm}
\usage{
seasonder_defaultMUSICOptions()
}
\value{
A list containing the default options for the MUSIC algorithm.
}
\description{
This function returns a list of default options used in the MUSIC algorithm.
}
\details{
The returned list includes:
\itemize{
\item \code{PPMIN}: Lower threshold value (default is \code{NULL}).
\item \code{PWMAX}: Upper threshold value (default is \code{NULL}).
\item \code{smoothNoiseLevel}: Logical flag indicating whether the noise level should be smoothed (\code{FALSE} by default).
\item \code{doppler_interpolation}: Doppler interpolation factor (default is \code{2}).
\item \code{MUSIC_parameters}: A numeric vector of default parameters for the MUSIC algorithm, retrieved from \code{seasonder_defaultMUSIC_parameters()}.
\item \code{discard_low_SNR}: Logical flag to discard solutions with low signal-to-noise ratio (\code{TRUE} by default).
\item \code{discard_no_solution}: Logical flag to discard cases with no solution (\code{TRUE} by default).
}
}
\examples{
# Retrieve the default options for the MUSIC algorithm
opts <- seasonder_defaultMUSICOptions()
print(opts)
}
