% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS_FOR.R
\name{seasonder_extractFOR}
\alias{seasonder_extractFOR}
\title{Extract First Order Region (FOR) Spectral Data}
\usage{
seasonder_extractFOR(seasonder_cs_object, spectrum, FOR)
}
\arguments{
\item{seasonder_cs_object}{A \code{SeaSondeRCS} object containing the spectral data.}

\item{spectrum}{A numeric matrix representing the self-spectra data for a single range cell.}

\item{FOR}{A list containing the Doppler bin indices defining the FOR region, with two elements:
- \code{negative_FOR}: A numeric vector of Doppler bins for the negative Bragg region.
- \code{positive_FOR}: A numeric vector of Doppler bins for the positive Bragg region.}
}
\value{
A list with two elements:
\itemize{
\item \code{negative_FOR}: A matrix containing spectral power for the negative Bragg region.
\item \code{positive_FOR}: A matrix containing spectral power for the positive Bragg region.
}
}
\description{
This function extracts the spectral power corresponding to the First Order Region (FOR)
from a given self-spectra (SS) matrix. It retrieves the spectral values within the
Doppler bins identified as part of the positive and negative Bragg regions.
}
\details{
The function performs the following steps:
\enumerate{
\item \strong{Initialize Empty Matrices:} Creates empty matrices to store extracted spectral data.
\item \strong{Extract Negative FOR Data:}
\itemize{
\item If the negative FOR bins exist, calls \code{\link{seasonder_extractSeaSondeRCS_dopplerRanges_from_SSdata}}
to extract the corresponding spectral values.
}
\item \strong{Extract Positive FOR Data:}
\itemize{
\item If the positive FOR bins exist, extracts the spectral values using the same function.
}
\item \strong{Return Extracted Spectral Data:} Outputs a list containing the extracted negative and positive
Bragg region spectral data.
}

This function is primarily used for filtering and validating the first-order Bragg region in
SeaSonde radar processing.
}
\seealso{
\itemize{
\item \code{\link{seasonder_extractSeaSondeRCS_dopplerRanges_from_SSdata}} for extracting Doppler bin subsets.
\item \code{\link{seasonder_filterFORAmplitudes}} for filtering weak FOR detections.
}
}
