% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeaSondeRCS.R
\name{seasonder_getSeaSondeRCS_headerField}
\alias{seasonder_getSeaSondeRCS_headerField}
\title{Retrieve a Specific Field from a SeaSondeRCS Header}
\usage{
seasonder_getSeaSondeRCS_headerField(seasonder_cs_object, field)
}
\arguments{
\item{seasonder_cs_object}{A SeaSondeRCS object.}

\item{field}{A string specifying the field name to retrieve from the header.}
}
\value{
The value of the specified field from the header. If the field is not found, NULL is returned.
}
\description{
This function extracts a specific field from the header of a SeaSondeRCS object.
}
\details{
This function first retrieves the full header using \code{\link{seasonder_getSeaSondeRCS_header}}
and then attempts to extract the requested field using \code{\link[purrr]{pluck}}. The header is
flattened before extraction to accommodate nested structures.
}
\seealso{
\code{\link{seasonder_getSeaSondeRCS_header}} for retrieving the full header.
\code{\link[purrr]{pluck}} for selective element extraction.
}
