% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{ver_map_chirps}
\alias{ver_map_chirps}
\title{Plot a verification map of percentiles based on precomputed CHIRPS quantiles.}
\usage{
ver_map_chirps(
  mm = month(Sys.Date() - 60),
  yy = year(Sys.Date() - 60),
  version = "UCSB",
  resolution = "low",
  ...
)
}
\arguments{
\item{yy, mm}{The year and month for which to show the verification map. Defaults to the month 60 days ago (in order to avoid using preliminary data).}

\item{version}{which CHIRPS version to use.}

\item{resolution}{Spatial resolution, 'high' or 'low'}

\item{...}{passed on to ver_map.}
}
\value{
A gg object
}
\description{
The quantiles should be computed and saved by the function \code{chirps_ver_map_quantiles}.
}
\examples{
\donttest{ # takes a while:
if(interactive()) ver_map_chirps(mm = 12,yy = 2022)
}

}
