% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_select_gamlss.R
\name{betareg_lasso_gamlss}
\alias{betareg_lasso_gamlss}
\title{Beta regression LASSO via GAMLSS}
\usage{
betareg_lasso_gamlss(
  X,
  Y,
  method = c("ML", "GAIC"),
  k = 2,
  degf = NULL,
  lambda = NULL,
  trace = FALSE
)
}
\arguments{
\item{X}{Numeric matrix (n × p) of mean-submodel predictors.}

\item{Y}{Numeric response in (0,1). Values are squeezed to (0,1) internally.}

\item{method}{\code{"ML"} or \code{"GAIC"} (see \code{gamlss::ri}).}

\item{k}{Penalty multiplier for GAIC when \code{method = "GAIC"}.}

\item{degf}{Optional degrees of freedom for the L1 term.}

\item{lambda}{Optional penalty strength.}

\item{trace}{Logical; print stepwise trace.}
}
\value{
Named numeric vector of coefficients \code{(Intercept)} + \code{colnames(X)},
with 0 for unselected variables.
}
\description{
Uses \code{gamlss::ri()} (L1 penalty) in a \code{gamlss(dist = BE)} mean submodel to
select variables. The helper works on complete cases of \code{X}/\code{Y}, targets the
mean component, and does not yet expose offset handling.
}
\examples{
set.seed(1); X <- matrix(rnorm(300), 100, 3); Y <- plogis(X[,1]); Y <- rbeta(100, Y*30, (1-Y)*30)
betareg_lasso_gamlss(X, Y, method = "GAIC", k = 2)
}
\seealso{
\code{\link[gamlss:gamlss]{gamlss::gamlss()}}, \code{\link[gamlss:ri]{gamlss::ri()}}, \code{\link[gamlss.dist:BE]{gamlss.dist::BE()}}
}
