% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_helpers.R
\name{plot_compare_coeff}
\alias{plot_compare_coeff}
\title{Side-by-side coefficient heatmap}
\usage{
plot_compare_coeff(single_tab)
}
\arguments{
\item{single_tab}{Data frame as returned by \code{compare_selectors_single()[["table"]]}.}
}
\value{
A \code{ggplot} object when \code{ggplot2} is available; otherwise draws a base R image.
}
\description{
Visual comparison of coefficients returned by each selector. Requires \code{ggplot2}.
}
\examples{
demo_tab <- data.frame(
  selector = rep(c("AIC", "BIC"), each = 3),
  variable = rep(paste0("x", 1:3), times = 2),
  coef = c(0.6, 0, -0.2, 0.55, 0.05, -0.3)
)
demo_tab$selected <- demo_tab$coef != 0
plot_compare_coeff(demo_tab)
}
