% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_outcome_modeler.R
\name{fit_SensIAT_single_index_fixed_coef_model}
\alias{fit_SensIAT_single_index_fixed_coef_model}
\alias{fit_SensIAT_single_index_fixed_bandwidth_model}
\title{Outcome Modeler for \code{SensIAT} Single Index Model.}
\usage{
fit_SensIAT_single_index_fixed_coef_model(
  formula,
  data,
  kernel = "K2_Biweight",
  method = "nmk",
  id = ..id..,
  initial = NULL,
  ...
)

fit_SensIAT_single_index_fixed_bandwidth_model(
  formula,
  data,
  kernel = "K2_Biweight",
  method = "nmk",
  id = ..id..,
  initial = NULL,
  ...
)
}
\arguments{
\item{formula}{The outcome model formula}

\item{data}{The data to fit the outcome model to.
Should only include follow-up data, i.e. time > 0.}

\item{kernel}{The kernel to use for the outcome model.}

\item{method}{The optimization method to use for the outcome model, either \code{"optim"}, \code{"nlminb"}, or \code{"nmk"}.}

\item{id}{The patient identifier variable for the data.}

\item{initial}{Either a vector of initial values or a function to estimate initial values.
If NULL (default), the initial values are estimated using the \code{MAVE::mave.compute} function.}

\item{...}{Currently ignored, included for future compatibility.}
}
\value{
Object of class \code{SensIAT::Single-index-outcome-model} which contains the outcome model portion.
}
\description{
Outcome Modeler for \code{SensIAT} Single Index Model.
}
\section{Functions}{
\itemize{
\item \code{fit_SensIAT_single_index_fixed_bandwidth_model()}: for fitting with a fixed bandwidth

}}
\examples{
\donttest{
# A basic example using fixed intensity bandwidth.
object <-
    fit_SensIAT_within_group_model(
        group.data = SensIAT_example_data,
        outcome_modeler = fit_SensIAT_single_index_fixed_bandwidth_model,
        id = Subject_ID,
        outcome = Outcome,
        time = Time,
        knots = c(60,260,460),
        End = 830,
        intensity.args=list(bandwidth=30)
    )

# A basic example using variable bandwidth but with fixed first coefficient.
object.bw <-
    fit_SensIAT_within_group_model(
        group.data = SensIAT_example_data,
        outcome_modeler = fit_SensIAT_single_index_fixed_coef_model,
        id = Subject_ID,
        outcome = Outcome,
        time = Time,
        knots = c(60,260,460),
        End = 830,
        intensity.args=list(bandwidth=30)
    )
}
}
