\name{cguess}
\alias{cguess}
\title{
Evaluate Optimal Guess
}
\description{
This function calculates the optimal guess for the allocation of the next observation in a sequential allocation scheme, and evaluates whether that guess is correct.
}
\usage{
cguess(alloc)
}
\arguments{
  \item{alloc}{
vector of zeroes and ones, indicating the allocation to treatment (1) and control (0)
}
}
\details{
Blackwell and Hodges (1957) proposed evaluating the predictability of a randomized allocation scheme by having an observer guess that the next unit would be allocated to the treatment arm that currently has fewer subjects. This function creates the guesses that would be generated by an observer following this strategy, then compares them with the actual allocation. If units 1 through j have more treatment than control units, then the observer guesses that observation j+1 is assigned to the control arm. If units 1 through j have more control than treatment units, then the observer guesses that observation j+1 is assigned to the treatment arm. If units 1 through j have the same number of control and treatment units, then the observer flips a coin with probability 0.5 for the allocation of the next unit. To reduce the variability in the percentage guessed correctly, this is recorded as a response of 0.5; however, the function is easily changed to allow the observer to guess treatment or control with probability 0.5 for that case.
}
\value{
Vector of length length(alloc) containing values 0, 0.5, and 1. A value is 1 if the guess is correct, 0 if it is incorrect, and 0.5 if the allocation preceding the observation in question was equal.
}
\references{
Blackwell, David and Hodges, J. L. (1957). Design for the Control of Selection Bias. Annals of Mathematical Statistics 28: 449-460.

Lohr, S. and X. Zhu (2015). Randomized Sequential Individual Assignment in Social Experiments: Evaluating the Design Options Prospectively. Sociological Methods and Research. [Advance online publication: December 27, 2015] doi: 10.1177/0049124115621332.
}
\author{
Xiaoshu Zhu \email{xiaoshuzhu@westat.com} and Sharon Lohr
}
\examples{
alloc <- rbinom(50,1,.5)

cguess(alloc)
}
\keyword{ Predictability }
\keyword{ Blackwell-Hodges }
