% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peakid.r
\name{peakid}
\alias{peakid}
\title{Function that identifies peaks in a dataset}
\usage{
peakid(x, y, w = 1, ...)
}
\arguments{
\item{x}{Vector of \code{x} values of input data}

\item{y}{Vector of \code{y} values of input data}

\item{w}{Window size for smoothing data}

\item{...}{Additional arguments to be passed into LOESS function}
}
\value{
A vector listing the standard deviations of propagated errors
propagated on all \code{X} values.
}
\description{
Developed by William A. Huber
}
\examples{
# Create dummy periodic data
x <- seq(1, 100, 1)
y <- sin((2 * pi * (seq(1, 100, 1) - 8 + 20 / 4)) / 20)
# Run peakid function
result <- peakid(x, y, w = 20)
}
\references{
package dependencies: zoo 1.8.7

Huber, W.A., Data Smoothing and Peak Detection, Rpubs,
Last accessed: December 8th, 2020.
\url{https://rpubs.com/mengxu/peak_detection}
}
\seealso{
https://rpubs.com/mengxu/peak_detection
}
