
source(paste(getwd(), "/R/Sie2nts.Legen.v1.R", sep = ""))
source(paste(getwd(), "/R/Sie2nts.Cheby.v1.R", sep = ""))
source(paste(getwd(), "/R/Sie2nts.Four.v1.R", sep = ""))
source(paste(getwd(), "/R/Sie2nts.Csp.v1.R", sep = ""))
source(paste(getwd(), "/R/Sie2nts.db1-20.v1.R", sep = ""))
source(paste(getwd(), "/R/sie.auto.fit.R", sep = ""))




#' The Test of Lag of Auto-Regressive (AR) Model Automatically
#' @description auto.pacf.test() generates a test of lag of AR model by choosing tuning parameter automatically.
#' @param ts ts is the data set which is a time series data typically
#' @param type type indicates which type of basis is used. There are 31 types in this package
#' @param lag the lag for auto-regressive model, the default value is 3
#' @param b the largest lag for auto-regressive model, the default value is 8, this parameter must be
#'     larger than lag
#' @param or or indicates the order of spline and only used in Cspli type, default is 4 which indicates cubic spline
#' @param alpha level of the test
#' @param method method indicates which method used to choose optimal parameters, 3 methods in this package can be used.
#' @param threshold threshold determines the bound for Elbow method
#' @param B.s the number of statistics used in multiplier bootstrap, the default value is 1000
#'
#' @details In the parameter type, this package provides 32 types of basis including options "Legen" for Legendre polynomials, "Cheby" for first kind
#'     Chebyshev polynomials, "tri" for trigonometric polynomials, "cos" for cosine polynomials, "sin" for sine polynomials, "Cspli" for splines means Class of splines
#'     functions, in this option, the first input "c" is knots plus 2 that represent 0 and 1. "or" indicates the order of splines, so the number of basis is number of knots + 2 - 2 plus
#'     the number of order.When functions automatically choose the number of basis for splines, the number is not less than the order of spline. "db1" to "db20" for Daubechies1 wavelet basis to Daubechies20
#'     wavelet basis and "cf1" to "cf5" for Coiflet1 wavelet basis to Coiflet5 wavelet basis. The package provides the wavelet tables are generated by Cascade algorithm using low-pass filter.
#'     If the exact values of wavelet are required, Recursion algorithm should be used.
#'     In the parameter method, it contains 3 options, the default option is "LOOCV", it uses Leave-One-Out Cross-Validation to choose the best tuning parameters. 
#'     The second choice is "CV" which uses the Cross-Validation method, it takes 3*log2(n) size as validation set where n is the number of total observations. 
#'     The third choice is "Elbow".This method similar as "lOOCV", however, it set the threshold manually. The function will choose the smallest tuning parameters 
#'     once the value of LOOCV is less than threshold.
#' @return p value of the test
#' @references \[1] Ding, Xiucai, and Zhou, Zhou. “Estimation and inference for precision matrices of nonstationary time series.” The Annals of Statistics 48(4) (2020): 2455-2477. 
#' @references \[2] Ding, Xiucai, and Zhou, Zhou. “Auto-regressive approximations to non-stationary time series, with inference and applications.” Available online, 2021.
#' @importFrom Matrix kronecker
#' @importFrom Matrix bdiag
#' @import ggplot2
#' @importFrom plotly plot_ly
#' @importFrom plotly layout
#' @importFrom plotly add_markers
#' @importFrom stats rnorm
#' @importFrom stats integrate
#' @import stringr
#' @import RCurl
#' @import splines
#' @import methods
#' @import utils
#' @export



auto.pacf.test = function(ts, lag = 3, b=8, or = 4, type, alpha = 0.05, method = "LOOCV", threshold = 0, B.s = 1000){
  wavelet_basis = c("db1", "db2", "db3", "db4", "db5",
                    "db6", "db7", "db8", "db9", "db10",
                    "db11", "db12", "db13", "db14", "db15",
                    "db16", "db17", "db18", "db19", "db20",
                    "cf1", "cf2", "cf3", "cf4", "cf5"
  )

  if(type == "Legen"){
    res = sie.auto.fit(ts, type = type, method = method, threshold = threshold)
    cat(paste("The significant level is",alpha, sep = " "))
    return(fit.testing.b.legen(ts, res$BC[1], lag, b = b, B.s = B.s, m = 0))
  } else if (type == "Cheby"){
    res = sie.auto.fit(ts, type = type, method = method, threshold = threshold)
    cat(paste("The significant level is",alpha, sep = " "))
    return(fit.testing.b.cheby(ts, res$BC[1], lag, b = b,  B.s = B.s, m = 0))
    fit.testing.b.four()
  } else if (type %in% c("tri", "cos", "sin")){
    res = sie.auto.fit(ts, type = type, method = method, threshold = threshold)
    cat(paste("The significant level is",alpha, sep = " "))
    return(fit.testing.b.four(ts, res$BC[1], lag, ops = type, b = b, B.s = B.s, m = 0))
  } else if (type == "Cspli"){
    res = sie.auto.fit(ts, type = type, method = method, threshold = threshold)
    cat(paste("The significant level is",alpha, sep = " "))
    return(fit.testing.b.cspline(ts, res$BC[1], or=or, lag, B.s = B.s, m = 0))
  } else if (type %in% wavelet_basis){
    res = sie.auto.fit(ts, type = type, method = method, threshold = threshold)
    cat(paste("The significant level is",alpha, sep = " "))
    return(fit.testing.b.wavelet(ts, res$BC[1], lag, ops = type, b = b, B.s = B.s, m = 0))
  } else{
    return(stop("Invalid option!"))
  }
}


