% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{filter_all}
\alias{filter_all}
\title{Apply Multiple Filters to a Series}
\usage{
filter_all(
  y,
  wavelet_wf = "la8",
  wavelet_J = 4,
  wavelet_levels = c(3, 4),
  hpgc_prior = "weak",
  hpgc_chains = 4,
  hpgc_iterations = 20000,
  hpgc_burnin = 5000,
  verbose = FALSE
)
}
\arguments{
\item{y}{Numeric vector of the time series.}

\item{wavelet_wf}{Wavelet filter for wavelet decomposition. Default "la8".}

\item{wavelet_J}{Wavelet decomposition depth. Default 4.}

\item{wavelet_levels}{Levels to combine for wavelet trend. Default c(3, 4).}

\item{hpgc_prior}{Prior configuration for HP-GC. Default "weak".}

\item{hpgc_chains}{Number of MCMC chains. Default 4.}

\item{hpgc_iterations}{MCMC iterations. Default 20000.}

\item{hpgc_burnin}{MCMC burn-in. Default 5000.}

\item{verbose}{Logical for progress messages.}
}
\value{
A list of class "signaly_multifilter" containing results from all
three methods and a comparison data frame.
}
\description{
Convenience function that applies all three filtering methods (wavelet, EMD,
HP-GC) to a time series and returns a consolidated comparison of results.
}
\examples{
\donttest{
y <- cumsum(rnorm(100)) + sin(seq(0, 4*pi, length.out = 100))
result <- filter_all(y, hpgc_iterations = 5000, hpgc_burnin = 1000)
}

}
