% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/non-overlap-measures.R
\name{Tau_U}
\alias{Tau_U}
\title{Tau-U}
\usage{
Tau_U(
  A_data,
  B_data,
  condition,
  outcome,
  baseline_phase = NULL,
  intervention_phase = NULL,
  improvement = "increase"
)
}
\arguments{
\item{A_data}{vector of numeric data for A phase, sorted in order of session 
number. Missing values are dropped.}

\item{B_data}{vector of numeric data for B phase. Missing values are dropped.}

\item{condition}{vector identifying the treatment condition for each
observation in the series.}

\item{outcome}{vector of outcome data for the entire series.}

\item{baseline_phase}{character string specifying which value of
\code{condition} corresponds to the baseline phase. Defaults to first
observed value of \code{condition}.}

\item{intervention_phase}{character string specifying which value of
\code{condition} corresponds to the intervention phase. Defaults to second
unique value of \code{condition}.}

\item{improvement}{character string indicating direction of improvement.
Default is "increase".}
}
\value{
Numeric value
}
\description{
Calculates the Tau-U index with baseline trend correction 
  (Parker, Vannest, Davis, & Sauber 2011).
}
\details{
Tau-U is an elaboration of the \code{\link{Tau}} that includes a 
  correction for baseline trend. It is calculated as Kendall's S statistic
  for the comparison between the phase B data and the phase A data, plus
  Kendall's S statistic for the A phase observations, scaled by the product
  of the number of observations in each phase.
  
  Note that \code{A_data} must be ordered by session number.
}
\examples{
A <- c(20, 20, 26, 25, 22, 23)
B <- c(28, 25, 24, 27, 30, 30, 29)
Tau_U(A_data = A, B_data = B)

}
\references{
Parker, R. I., Vannest, K. J., Davis, J. L., & Sauber, S. B. 
  (2011). Combining nonoverlap and trend for single-case research: Tau-U. 
  \emph{Behavior Therapy, 42}(2), 284--299. 
  doi:\doi{10.1016/j.beth.2010.08.006}
}
