% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aa_generics.R, R/class_Tradeoff.R,
%   R/class_Slick.R
\docType{methods}
\name{Tradeoff}
\alias{Tradeoff}
\alias{Tradeoff<-}
\alias{Tradeoff,missing-method}
\alias{Tradeoff,character-method}
\alias{Tradeoff,list-method}
\alias{Tradeoff,Slick-method}
\alias{Tradeoff<-,Slick-method}
\title{Methods for Creating, Accessing and Assigning \code{Tradeoff} objects}
\usage{
Tradeoff(
  Code = "",
  Label = "",
  Description = "",
  Value = array(),
  Preset = list()
)

Tradeoff(Slick) <- value

\S4method{Tradeoff}{missing}()

\S4method{Tradeoff}{character}(
  Code = "",
  Label = "",
  Description = "",
  Value = array(),
  Preset = list()
)

\S4method{Tradeoff}{list}(
  Code = "",
  Label = "",
  Description = "",
  Value = array(),
  Preset = list()
)

\S4method{Tradeoff}{Slick}(Code)

\S4method{Tradeoff}{Slick}(Slick) <- value
}
\arguments{
\item{Code}{A \emph{short} code for the Performance Indicators for this object.
A character string length \code{nPI} or a named list for multi-language support. See \code{Details}}

\item{Label}{A short label for the Performance Indicators for this object. Used to label axes on charts.
Can be longer than \code{Code} but recommended to keep short as possible so it shows clearly in plots and tables.
A character string length \code{nPI} or a named list for multi-language support. See \code{Details}}

\item{Description}{A description for the Performance Indicators for this object.
Can include Markdown, see \code{Examples}.
A character string length \code{nPI} or a named list for multi-language support. See \code{Details}}

\item{Value}{A numeric array with the stochastic performance indicator values for each
operating model (OM), management procedure (MP),  and performance indicator (PI)
Dimensions: c(\code{nOM}, \code{nMP}, \code{nPI})}

\item{Preset}{An optional named list for the preset buttons in the \code{\link[=App]{App()}}. The name of the list
element will appear as a button in the \code{\link[=App]{App()}}.}

\item{Slick}{A \code{\link[=Slick-class]{Slick-class()}} object}

\item{value}{A \code{\link[=Tradeoff-class]{Tradeoff-class()}} object}
}
\description{
The \code{Tradeoff} function is used both to create and modify an \code{\link[=Tradeoff-class]{Tradeoff-class()}} object.
and to access and assign \code{Tradeoff} for an object of class \code{\link[=Slick-class]{Slick-class()}}.
See \code{Details}.
}
\details{
Objects of class \code{Tradeoff} are created with \code{Tradeoff()}
\subsection{Multi-Language Support}{

Text with multi-language supported can be provided as a named list. Available languages:
\itemize{
\item \code{en}: English (default)
\item \code{es}: Spanish
\item \code{fr}: French
}
}

\subsection{Note}{

Character strings in \code{Code}, \code{Label}, and \code{Description} must all be same length
as the number of performance indicators (\code{nPIs}) in \code{Value}
}
}
\section{Functions}{
\itemize{
\item \code{Tradeoff(missing)}: Create an empty \code{Tradeoff} object

\item \code{Tradeoff(character)}: Create a populated \code{Tradeoff} object

\item \code{Tradeoff(list)}: Create a populated \code{Tradeoff} object

\item \code{Tradeoff(Slick)}: Return \code{Tradeoff} from a \code{\link[=Slick-class]{Slick-class()}} object

\item \code{Tradeoff(Slick) <- value}: Assign a \code{\link[=Tradeoff-class]{Tradeoff-class()}} object to a \code{\link[=Slick-class]{Slick-class()}} object

}}
\examples{
# Generate dummy values
nOM <- 2
nMP <- 4
nPI <- 4

values <- array(NA, dim=c(nOM, nMP, nPI))

pi_means <- runif(nPI, 5, 50)
for (om in 1:nOM) {
  for (mp in 1:nMP) {
    for (pi in 1:nPI) {
      values[om, mp, pi] <- rlnorm(1,log(pi_means[pi]), 0.4)
    }
  }
}

# Create and populate Object
tradeoff <- Tradeoff(Code=c('PI1', 'PI2', 'PI3', 'PI4'),
               Label=c('Performance Indicator 1',
                       'Performance Indicator 2',
                       'Performance Indicator 3',
                       'Performance Indicator 4'),
               Description = c('This is the description for PI 1',
                               'This is the description for PI 2',
                               'This is the description for PI 3',
                               'This is the description for PI 4'),
               Value=values)

# Check
Check(tradeoff)

# Add to `Slick` object
slick <- Slick()
Tradeoff(slick) <- tradeoff

# Plots
plotTradeoff(slick)

plotTradeoff(slick, c(1,1,2), c(2,3,3))
}
\seealso{
\code{\link[=Code]{Code()}}, \code{\link[=Label]{Label()}}, \code{\link[=Description]{Description()}}, \code{\link[=Metadata]{Metadata()}}, \code{\link[=Value]{Value()}}, \code{\link[=Preset]{Preset()}}
}
