% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simSurvIC.R
\name{survIC}
\alias{survIC}
\alias{survModelIC}
\title{Generate survival model objects}
\usage{
survIC(
  scale.time = 1/100,
  shape.time = 1,
  n.inspections = 5,
  schedule = 10,
  punctuality = 5
)
}
\arguments{
\item{scale.time}{Weilbull scale for latent time}

\item{shape.time}{Weilbull shape for latent time}

\item{n.inspections}{Number of inspection times}

\item{schedule}{Mean of the waiting time between adjacent
inspections.}

\item{punctuality}{Standard deviation of waiting time between
inspections.}
}
\value{
A latent variable model object \code{lvm}
}
\description{
Function to generate a latent variable model for interval censored survival times.
}
\details{
Based on the functionality of the lava PACKAGE the function generates
a latent variable model with a latent time
and a censoring mechanism (censtime, inspection1,inspection2,...,inspectionK).

The function \link{sim.survIC} then simulates
interval censored times.
}
\examples{
\donttest{
library(lava)
library(prodlim)
# generate survival model based on exponentially
# distributed times
m <- survIC(scale.time=1/50, shape.time=0.7)
round(sim(m,6),1)

# Estimate the parameters of the Weibull models
# based on the uncensored exact event times
# and the uncensored illstatus.
set.seed(18)
d <- sim(m,100,latent=FALSE)
d$uncensored.status <- 1
f <- shr(Hist(time=list(L,R),event=uncensored.status)~1,
         data=d,
         conf.int=FALSE)
print(f)
}
}
\author{
Thomas Alexander Gerds
}
