% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sobol4r_design.R
\name{sobol4r_design}
\alias{sobol4r_design}
\title{Design generation for Sobol indices}
\usage{
sobol4r_design(
  X1,
  X2,
  order = 2,
  nboot = 0,
  type = c("soboljansen", "sobol", "sobol2007", "sobolEff", "sobolmartinez"),
  ...
)
}
\arguments{
\item{X1}{First sample (matrix or data.frame).}

\item{X2}{Second sample (matrix or data.frame).}

\item{order}{Maximum interaction order (1 or 2).}

\item{nboot}{Number of bootstrap replicates for confidence intervals.}

\item{type}{Type of Monte Carlo Estimation of Sobol' Indices to be used.
Supported estimators mirror the \pkg{sensitivity} helpers: \code{sobol},
\code{sobol2007}, \code{soboljansen}, \code{sobolEff}, and
\code{sobolmartinez}. Defaults to \code{"soboljansen"}, which is the
safest general-purpose choice for both deterministic and stochastic
simulators.}

\item{...}{Additional arguments passed to \code{sensitivity::sobol}.}
}
\value{
An object of class \code{"sobol"} whose \code{$X} field contains
the design matrix. You should evaluate your model on \code{$X} and
then call \code{sensitivity::tell()}.
}
\description{
Simple helper that wraps \code{sensitivity::sobol} with \code{model = NULL}
to create the extended design matrix used to evaluate the model.
}
