% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sobol4r_run.R
\name{sobol4r_run}
\alias{sobol4r_run}
\title{Run Sobol analysis with optional QoI wrapper}
\usage{
sobol4r_run(
  model,
  X1,
  X2,
  order = 2,
  nboot = 100L,
  qoi_fun = NULL,
  nrep = 1L,
  type = c("soboljansen", "sobol", "sobol2007", "sobolEff", "sobolmartinez"),
  ...
)
}
\arguments{
\item{model}{Deterministic or stochastic model that takes a design X
and returns a numeric vector of length nrow(X).}

\item{X1, X2}{Matrices or data.frames used to build the Sobol design.}

\item{order}{Order of the Sobol indices (1 or 2).}

\item{nboot}{Number of bootstrap replicates for confidence intervals.}

\item{qoi_fun}{Optional quantity of interest function. If not NULL,
the model is evaluated repeatedly and QoI is computed row wise.}

\item{nrep}{Number of replications per design row when \code{qoi} is not NULL.}

\item{type}{Type of Monte Carlo Estimation of Sobol' Indices to be used.
Supported estimators mirror the \pkg{sensitivity} helpers: \code{sobol},
\code{sobol2007}, \code{soboljansen}, \code{sobolEff}, and
\code{sobolmartinez}. Defaults to \code{"soboljansen"} because it offers
robust first and total order indices on both centred and non-centred
outputs.}

\item{...}{Extra arguments passed to \code{model}.}
}
\value{
A \code{sobol} object (output of \code{sensitivity::tell}).
}
\description{
Helper around \code{sensitivity::sobol} that mimics the structure
of the original scripts. It never writes to disk.
}
