% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/C_input.R
\name{C_input}
\alias{C_input}
\title{Estimate carbon input}
\usage{
C_input(var_MGMT_data, extended.output = FALSE)
}
\arguments{
\item{var_MGMT_data}{a \code{management_df} that contains the management information}

\item{extended.output}{an optional logical value.
\itemize{
\item If FALSE, C input values are aggregated by year.
\item If TRUE, a tibble with daily resolution is returned.
\item Default value is FALSE
}}
}
\value{
\itemize{
\item By default, a tibble with C input values (total and by category)
by year is returned.
\item If \code{extended.output = TRUE}, a tibble with all management operations and their
respecitve C inputs is returned.
}
}
\description{
\code{\link[=C_input]{C_input()}} estimates the carbon (C) input into the soil system per year of a
\code{management_df}.
}
\details{
The function takes a \code{management_df} as input and returns
a C input values per year in the \code{management_df}.

Alternatively, it can return a tibble with all managememnt operations and
their respective C input values.

The functions calculates the C input with the \code{\link[=C_input_crops]{C_input_crops()}},
\code{\link[=C_input_cover_crops]{C_input_cover_crops()}} and \code{\link[=CN_input_amendments]{CN_input_amendments()}} functions.
}
\examples{
#example that returns annual C input values
C_input(EXAMPLE_data)

#example that returns a tibble with all operations that have a C input
C_input(EXAMPLE_data, extended.output = TRUE)

}
\seealso{
\itemize{
\item \code{\link[=calculate_indicators]{calculate_indicators()}} to calculate all management indicators
for a \code{management_df}
\item \code{\link[=calculate_C_input_tibble]{calculate_C_input_tibble()}} a helper function that calculates the C input tibble
\item \code{\link[=C_input_crops]{C_input_crops()}} to calculate C input for crops
\item \code{\link[=C_input_cover_crops]{C_input_cover_crops()}} to calculate C input for cover crops
\item \code{\link[=CN_input_amendments]{CN_input_amendments()}} to calculate C (and N) inputs for organic amendments
}
}
