% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicators_by_date.R
\name{indicators_by_date}
\alias{indicators_by_date}
\title{Extract indicators by a specific date}
\usage{
indicators_by_date(
  var_management_df,
  var_date,
  half_life_time_STIR = 365,
  half_life_time_C_input = 365,
  half_life_time_N_input = 365,
  half_life_time_soil_cover = 365
)
}
\arguments{
\item{var_management_df}{input management data frame}

\item{var_date}{date of the extraction in the format "YYYY-MM-DD"}

\item{half_life_time_STIR}{half life time for the discounting of the STIR value}

\item{half_life_time_C_input}{half life time for the discounting of the C inputs}

\item{half_life_time_N_input}{half life time for the discounting of the N inputs}

\item{half_life_time_soil_cover}{half life time for the discounting of soil cover days}
}
\value{
tibble with the discounted indicator values per date
}
\description{
Calculate for a specific date (e.g. day of sampling) and discount the 
indicator values of events in the past. The default half life time of all 
discounts is set to 1 year (365 days).
}
\examples{
# calculate indicators by a specific date
\donttest{
  indicators_by_date(EXAMPLE_data, "2019-10-03")
 }
# this would return a tibble, but it may take a while

}
