% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turnoverFit.R
\name{turnoverFit}
\alias{turnoverFit}
\title{Estimation of the turnover time from a radiocarbon sample.}
\usage{
turnoverFit(obsC14, obsyr, yr0, Fatm, plot = TRUE, by = 0.5)
}
\arguments{
\item{obsC14}{a scalar with the observed radiocarbon value in Delta14C}

\item{obsyr}{a scalar with the year in which the sample was taken.}

\item{yr0}{The year at which simulations will start.}

\item{Fatm}{an atmospheric radiocarbon curve as data.frame. First column 
must be time.}

\item{plot}{logical. Should the function produce a plot?}

\item{by}{numeric. The increment of the sequence of years used in the
simulations.}
}
\value{
A numeric vector with two values of the turnover time that minimize the
difference between the prediction of a one pool model and the observed
radiocarbon value.
}
\description{
This function finds two possible values of turnover time from 
radiocarbon sample assuming a one pool model with carbon at equilibrium.
}
\details{
This algorithm takes an observed radiocarbon value and 
runs \code{\link{OnepModel14}}, calculates the squared difference
between predictions and observations, and uses \code{\link{optimize}} to
find the minimum difference.
}
