% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{soil}
\alias{soil}
\title{Soil variables}
\format{
A data frame in tidy format with 504 observations on the following 5 variables:
\describe{
\item{\code{Feature}}{soil variables, 8 levels}
\item{\code{location}}{locations, 63 levels (observed locations in the historical series)}
\item{\code{Soil_Grid}}{mean values of the soil variables (Feature)}
\item{\code{LAT}}{location latitude}
\item{\code{LON}}{location longitude}
}
}
\source{
\describe{
Krause, M. D., Dias, K. O. G., Singh, A. K., and Beavis. W. D. (2022). Using large
soybean historical data to study genotype by environment variation and
identify mega-environments with the integration of genetic and non-genetic
factors. bioRxiv, \doi{doi:10.1101/2022.04.11.487885}
}
}
\usage{
soil
}
\description{
Soil variables in a depth interval of 5 to 15 cm were obtained from Soilgrids
(\url{https://soilgrids.org/}) for the 63 observed locations in the historical
series analyzed by Krause et al. (2022). The R code used to download and
process the soil data can be retrieved at \url{https://github.com/mdkrause/VarComp-ME/blob/main/soil_data.R}.
}
\details{
Levels of \code{Feature}:
\describe{
\item{bdod_5-15cm_mean:}{Bulk density of the fine earth fraction (cg/m\eqn{^3})}
\item{cec_5-15cm_mean:}{Cation Exchange Capacity of the soil (mmol(c)/kg)}
\item{clay_5-15cm_mean:}{Proportion of clay particles (< 0.002 mm) in the fine earth fraction (g/kg)}
\item{nitrogen_5-15cm_mean:}{Total nitrogen (cg/kg)}
\item{phh2o_5-15cm_mean:}{Soil pH (pH\eqn{\times}10)}
\item{sand_5-15cm_mean:}{Proportion of sand particles (\eqn{>} 0.05 mm) in the fine earth fraction (g/kg)}
\item{silt_5-15cm_mean:}{Proportion of silt particles (\eqn{\ge} 0.002 mm and \eqn{\leq} 0.05 mm) in the fine earth fraction (g/kg)}
\item{soc_5-15cm_mean:}{Soil organic carbon content in the fine earth fraction (dg/kg)}
}
}
\keyword{datasets}
