% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GC.R
\name{GC}
\alias{GC}
\alias{G}
\alias{dGC}
\alias{pGC}
\alias{qGC}
\alias{rGC}
\title{Gamma-Count (GC) Distribution}
\usage{
G(alpha, gamma)

dGC(y, alpha, gamma)

pGC(q, alpha, gamma, lower.tail = TRUE)

qGC(p, alpha = 1, gamma)

rGC(n = 1, alpha = 1, gamma = gamma, method = "PF")
}
\arguments{
\item{alpha}{the dispersion parameter of GC: default is 1; (shape parameter of waiting time variable);}

\item{gamma}{the rate parameter of GC and waiting time variable;}

\item{y}{a vector or matrix of observations for which the pdf needs to be computed.}

\item{q}{a vector or matrix of quantiles for which the cdf needs to be computed.}

\item{lower.tail}{logical; if TRUE (default), probabilities are
\eqn{P(Y \ge y)}; otherwise, \eqn{P(Y > y)}.}

\item{p}{a vector or matrix of probabilities for which the quantile needs to be computed.}

\item{n}{number of random values to be generated.}

\item{method}{Character string. The method used for generating random variables from the GC distribution in `rGC`. Options are:
- `"PF"`: Based on the probability function.
- `"IT"`: Inverse transformation method based on the quantile function.
- `"WT"`: Based on the waiting times distribution.}
}
\value{
\code{G} gives the G function,
 \code{pGC} gives the distribution function,
 \code{dGC} gives the density,
 \code{qGC} gives the quantile function and
 \code{rGC} generates random variables from the GC Distribution.
}
\description{
Density, distribution function, quantile function and random
generation for the GC distribution with
parameters \eqn{\alpha} and \eqn{\gamma}.
}
\details{
The GC distribution with parameters  \eqn{\alpha} and \eqn{\gamma}
has the density
\deqn{P(Y_T=y)=G(y\alpha,\gamma T)-G\left(\left(y+1\right)\alpha,\gamma T\right)}
where \deqn{G(n\alpha,\gamma T)=\frac{1}{\Gamma(n\alpha)}\int_{0}^{\gamma T} u^{n\alpha-1}\exp(-u)du}
for \eqn{\alpha} and \eqn{\lambda} which must be positive
values and \eqn{y \in \{0, 1, 2, \ldots\}}.
}
\examples{
# In a study, the number of disease incidence, we will calculate
# the probability that the number of disease is zero with rate 1
dGC(0, alpha = 1, gamma = 1)

# the probability that the disease will receive at least one
pGC(q = 1, alpha = 1, gamma = 1, lower.tail = FALSE)
# the probability that the disease will receive at most three
pGC(q = 3, alpha = 1, gamma = 1, lower.tail = TRUE)
# Calcaute the quantiles
qGC(p = c(0.25, 0.5, 0.75), alpha = 1, gamma = 1)
# Simulate 10 values from GC(1, 1)
rGC(n = 10, alpha = 1, gamma = 1, method = "PF")
}
\references{
Winkelmann, R. (1995). Duration dependence and dispersion in count-data models.
         \emph{Journal of Business & Economic Statistics}, 13(4):467-474.
     Nadifar, M., Baghishani, H., and Fallah, A. (2023). A flexible
         generalized poisson likelihood for spatial counts constructed by renewal theory, motivated by groundwater
           quality assessment.
           \emph{Journal of Agricultural, Biological, and Environmental Statistics},
                  28:726-748.
       \emph{Neutrosophic Sets and Systems},  22, 30-38.
}
