% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatGEO.R
\name{spatGEO}
\alias{spatGEO}
\title{Generate Spatial Random Fields from Matern Covariance Model}
\usage{
spatGEO(m, sigma, range)
}
\arguments{
\item{m}{Integer. The number of knots (or spatial units) for which the spatial random field should be generated.}

\item{sigma}{Numeric. The variance of the spatial random effects with Matern covariance. Must be positive.}

\item{range}{Numeric. The range of the spatial random effects with Matern covariance. Must be positive.}
}
\value{
A numeric vector representing the spatial random field from the Matern covariance model.
        The length of the vector is equal to the number of knots specified by the parameter `m`.
}
\description{
This function generates spatial random fields from the Matern covariance model for geospatial data.
Given a number of knots, a variance parameter, and a range parameter, the function produces
a spatial random field from the Matern covariance model.
}
\details{
The function starts by converting the variance (`sigma`) and range (`range`) parameters into the tau and kappa
parameters required for the Matern covariance model. Then, it constructs a mesh for the given number of knots,
defining the spatial layout of the data. The function uses INLA functions (`inla.spde2.matern` and others) to
create an SPDE object and set the priors for the spatial model. It then projects the mesh and constructs a predictor
for the model. Finally, the function calculates the precision matrix, samples from the distribution, and computes
the spatial random field using the A matrix and sampled values.
}
\examples{

\donttest{
# Generate a spatial random field from the Matern covariance model
# using 100 knots, variance = 1, and range = 1
spatial_random_field <- spatGEO(m = 100, sigma = 1, range = 1)
print(spatial_random_field)
}

}
