% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_grid.R
\name{create_grid_rectangular}
\alias{create_grid_rectangular}
\alias{create_grid_hexagonal}
\title{Create grid}
\usage{
create_grid_rectangular(
  geometry,
  cell_size,
  side_offset = 0,
  only_inside = FALSE
)

create_grid_hexagonal(
  geometry,
  cell_size,
  side_offset = 0,
  only_inside = FALSE
)
}
\arguments{
\item{geometry}{\code{\link[sf]{sf}} \code{data.frame} containing geometry which should be cover by
the grid.}

\item{cell_size}{\code{numeric} specifying the distance for equally spaced centers of polygons
(rectangular or hexagonal).}

\item{side_offset}{\code{numeric} specifying the side offset, distance added to the convex hull
of input geometry to generate grid for KDE. Good estimate is usually the same value as band width of KDE.}

\item{only_inside}{\code{logical} specifying if the grid cells should be generated only inside of the
geometry. Default value is \code{FALSE}.}
}
\value{
\code{\link[sf]{sf}} \code{data.frame}.
}
\description{
Create grid of equally spaced rectangles or hexagons. The distance between centre points
in both x and y dimension is equal to \code{cell_size}. The function is effectively a wrapper around
\code{\link[sf]{st_make_grid}} with a little bit of preprocessing including generation of grid only inside
\code{\link[sf]{st_convex_hull}}.
}
\section{Functions}{
\itemize{
\item \code{create_grid_rectangular()}: Create rectangular grid

\item \code{create_grid_hexagonal()}: Create hexagonal grid

}}
\examples{
library(sf)
nc <- st_read(system.file("shape/nc.shp", package = "sf")) \%>\% st_transform(32031)
grid <- create_grid_hexagonal(nc, cell_size = 100000)
grid <- create_grid_rectangular(nc, cell_size = 100000, only_inside = TRUE)

}
