% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/huff.R
\name{plotHuff}
\alias{plotHuff}
\title{Plot a Huff Raster}
\usage{
plotHuff(x, add = FALSE)
}
\arguments{
\item{x}{raster; output of the \code{\link{rasterHuff}} function.}

\item{add}{logical; if TRUE the raster is added to the current plot, if FALSE 
the raster is displayed in a new plot.}
}
\value{
Display the raster nicely.
}
\description{
This function plots the raster produced by the 
\code{\link{rasterHuff}} function.
}
\examples{
data(hospital)
# Compute Huff catchment areas from known points (hospital) on a
# grid defined by its resolution
myhuff <- huff(knownpts = hospital, varname = "capacity",
               typefct = "exponential", span = 750, beta = 2,
               resolution = 100, mask = paris, returnclass = "sf")
# Create a raster of huff values
myhuffraster <- rasterHuff(x = myhuff, mask = paris)
plotHuff(myhuffraster)
}
\seealso{
\link{huff}, \link{rasterHuff}.
}
