% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spectran-package.R
\docType{package}
\name{Spectran-package}
\alias{Spectran-package}
\alias{_PACKAGE}
\title{Spectran: Visual and Non-Visual Spectral Analysis of Light}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

Analyse light spectra for visual and non-visual (often called melanopic) needs, wrapped up in a Shiny App. 'Spectran' allows for the import of spectra in various CSV forms but also provides a wide range of example spectra and even the creation of own spectral power distributions. The goal of the app is to provide easy access and a visual overview of the spectral calculations underlying common parameters used in the field. It is thus ideal for educational purposes or the creation of presentation ready graphs in lighting research and application. 'Spectran' uses equations and action spectra described in CIE S026 (2018) \doi{10.25039/S026.2018}, DIN/TS 5031-100 (2021) \doi{10.31030/3287213}, and ISO/CIE 23539 (2023) \doi{10.25039/IS0.CIE.23539.2023}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/LiTGde/Spectran}
  \item \url{https://litgde.github.io/Spectran/}
  \item \doi{10.5281/zenodo.11518043}
  \item Report bugs at \url{https://github.com/LiTGde/Spectran/issues}
}

}
\author{
\strong{Maintainer}: Johannes Zauner \email{spectran@litg.de} (\href{https://orcid.org/0000-0003-2171-4566}{ORCID}) [copyright holder]

Other contributors:
\itemize{
  \item LiTG (www.litg.de) [funder, copyright holder]
}

}
\keyword{internal}
