% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_functions.R
\name{integrate_similarity_matrices}
\alias{integrate_similarity_matrices}
\title{integrate_similarity_matrices: integrate similarity matrices using a tensor product graph
linear combination and diffusion technique}
\usage{
integrate_similarity_matrices(kernellist, KNNs_p = 10,
  diffusion_iters = 4, method = "TPG")
}
\arguments{
\item{kernellist}{A list of similarity matrices: those to be integrated}

\item{KNNs_p}{Numerical value: number of nearest neighbours for KNN graph (default=10, suggested=10-20)}

\item{diffusion_iters}{Numerical value: number of iterations for graph diffusion (default=4, suggested=2-6)}

\item{method}{Character: either TPG (see reference below) or mean (default=TPG)}
}
\value{
An integrated similarity matrix
}
\description{
Given a list of similarity matrices this function will integrate them running
the Shu algorithm, also can reduce noise if the input is a list consisting of
a single matrix.
}
\examples{
i_test <- integrate_similarity_matrices(misslfilled,method='mean')
}
\references{
Shu, Le, and Longin Jan Latecki. "Integration of single-view graphs with 
diffusion of tensor product graphs for multi-view spectral clustering." Asian Conference 
on Machine Learning. 2016.
}
