% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SphereOptimize.R
\name{to.Sphere}
\alias{to.Sphere}
\title{Converting Cartesian coordinates to spherical coordinates}
\usage{
to.Sphere(s)
}
\arguments{
\item{s}{A list of Cartesian coordinates.}
}
\value{
A vector of the corresponding angles in spherical coordinating system.
}
\description{
The function to.Sphere convert a list of Cartesian coordinates representing a point
on a unit sphere to the corresponding spherical coordinates.
}
\examples{
s = from.Sphere(c(pi/3, pi/4, pi/5))
theta = to.Sphere(s)
theta = round(theta, 5)
theta == round(c(pi/3, pi/4, pi/5), 5)
}
