% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canonicalSVD.R
\name{canonicalSVD}
\alias{canonicalSVD}
\title{singular value decomposition}
\usage{
canonicalSVD(X)
}
\arguments{
\item{X}{the input matrix}
}
\value{
S

U

V
}
\description{
Computes a reduced SVD without sign ambiguity. Our convention is that
the sign of each vector in U is chosen such that the coefficient
with largest absolute value is positive.
}
\examples{
nu = 10
n = 350
m = 100
A_gamma <- rbind(matrix(0,n,m),-diag(m)/sqrt(nu))
svd.result = canonicalSVD(A_gamma)
S <- svd.result$S
S <- diag(S)
V <- svd.result$V
}
