% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_binary_matrix.R
\name{build_binary_matrix}
\alias{build_binary_matrix}
\title{Build binary presence/absence matrix of sporulation genes}
\usage{
build_binary_matrix(df)
}
\arguments{
\item{df}{A data.frame from \code{sporulation_gene_name()} with columns \code{genome_ID} and \code{spo_gene_name}.}
}
\value{
A wide-format binary matrix with genomes in rows and genes in columns.
}
\description{
Transforms the output of \code{sporulation_gene_name()} into a wide-format matrix
indicating the presence (1) or absence (0) of each sporulation-associated gene per genome.
}
\examples{
# Load package
library(SpoMAG)

# Load example annotation tables
file_spor <- system.file("extdata", "one_sporulating.csv.gz", package = "SpoMAG")
file_aspo <- system.file("extdata", "one_asporogenic.csv.gz", package = "SpoMAG")

# Read files
df_spor <- readr::read_csv(file_spor, show_col_types = FALSE)
df_aspo <- readr::read_csv(file_aspo, show_col_types = FALSE)

# Step 1: Extract sporulation-related genes
genes_spor <- sporulation_gene_name(df_spor)
genes_aspo <- sporulation_gene_name(df_aspo)

# Step 2: Convert to binary matrix
bin_spor <- build_binary_matrix(genes_spor)
bin_aspo <- build_binary_matrix(genes_aspo)

}
