% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{data.cumret}
\alias{data.cumret}
\title{Compute Cumulative Returns of a Vector.}
\usage{
data.cumret(df_ret, initial_eq)
}
\arguments{
\item{df_ret}{an xts object of asset returns, with dates as rownames.}

\item{initial_eq}{a numeric value representing the initial wealth.}
}
\value{
An xts object of wealth generated over time.
}
\description{
This function takes a vector of asset returns and computes the cumulative wealth
generated over time, assuming that the initial wealth was \code{initial_eq}.
}
\examples{

# Compute cumulative returns of an asset vector
library(quantmod)
asset_returns_xts <- xts(c(29.2, 30.0, 36.2, 30.4, 38.5, -35.6, 34.5),
                         order.by = as.Date(c("2023-05-01", "2023-05-02", "2023-05-03",
                                               "2023-05-04", "2023-05-05", "2023-05-06",
                                               "2023-05-07")))
data.cumret(asset_returns_xts, initial_eq = 100)


}
\seealso{
\code{\link{weekly_return}}, \code{\link{monthly_return}}, \code{\link{annual_return}}
}
