% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survMC.R
\name{survMC}
\alias{survMC}
\title{Survival analysis using Cox Proportional Hazards with MCMC.}
\usage{
survMC(m, n, Time, Event, chains, adapt, iter, data)
}
\arguments{
\item{m}{Starting column number from where variables of high dimensional data will get selected.}

\item{n}{Ending column number till where variables of high dimensional data will get selected.}

\item{Time}{Variable/Column name containing the information on duration of survival}

\item{Event}{Variable/Column name containing the information of survival event}

\item{chains}{Number of chains to perform}

\item{adapt}{Number of adaptations to perform}

\item{iter}{Number of iterations to perform}

\item{data}{High dimensional data having survival duration and event.}
}
\value{
Data set containing Posterior HR estimates, SD and quantiles.
}
\description{
Performs survival analysis using Cox Proportional Hazards with MCMC.
}
\details{
The survival columns of the data should be arranged as follows -
Death Death status=1 if died otherwise 0.
OS Survival duration measured as 'OS'
t.len Number of censored times
}
\examples{
\donttest{
##
data(mcsurv)
survMC(m=4,n=8,Time="OS",Event="Death",chains=2,adapt=100,iter=1000,data=mcsurv)
##
}
}
\references{
Bhattacharjee, A. (2020). Bayesian Approaches in Oncology Using R
and OpenBUGS. CRC Press.
}
\seealso{
survintMC
}
\author{
Atanu Bhattacharjee and Akash Pawar
}
