% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_configuration.R
\name{create_configurations}
\alias{create_configurations}
\title{Create Default Configuration for SveltePlot Charts}
\usage{
create_configurations(
  id = "",
  data = NULL,
  header = "",
  height = 500,
  show_legend = TRUE,
  xaxis_ticks = 6,
  dx = "0em",
  dy = "0em",
  rotation_xaxis = 0,
  font_size_xaxis = 14,
  font_size_xticks = 12,
  scale_x = "linear",
  dominant_baseline_x_axis = "middle",
  text_anchor_x_axis = "middle",
  x_axis_type = NULL,
  x_label = NULL,
  format_xaxis = NULL,
  format_yaxis = ",.3r",
  yaxis_ticks = 6,
  font_size_yaxis = 14,
  font_size_yticks = 12,
  format_tooltip = ".2~f",
  y_label = NULL,
  tooltip = NULL,
  interval = NULL,
  time_interval = NULL,
  colors = c("#1F77B4", "#FF7F0E", "#2CA02C", "#D62728", "#9467BD", "#8C564B", "#E377C2",
    "#7F7F7F", "#BCBD22", "#17BECF")
)
}
\arguments{
\item{id}{Unique identifier for the chart.}

\item{data}{Data frame containing the data to be plotted.}

\item{header}{Chart title or header text.}

\item{height}{Height of the chart in pixels.}

\item{show_legend}{Logical; if TRUE, displays the chart legend.}

\item{xaxis_ticks}{Suggested number of ticks on the x-axis.}

\item{dx}{Horizontal shift for the x-axis labels, typically in em units.}

\item{dy}{Vertical shift for the x-axis labels, typically in em units.}

\item{rotation_xaxis}{Rotation angle for x-axis tick labels, in degrees.}

\item{font_size_xaxis}{Font size for the x-axis label.}

\item{font_size_xticks}{Font size for the x-axis tick labels.}

\item{scale_x}{Scale type for the x-axis ("linear" or "log").}

\item{dominant_baseline_x_axis}{Dominant baseline for x-axis labels.}

\item{text_anchor_x_axis}{Text anchor point for x-axis labels.}

\item{x_axis_type}{Type of x-axis, if applicable (e.g., "date").}

\item{x_label}{Label for the x-axis.}

\item{format_xaxis}{Format string for x-axis labels, following D3 format specifications.}

\item{format_yaxis}{Format string for y-axis labels, following D3 format specifications.}

\item{yaxis_ticks}{Suggested number of ticks on the y-axis.}

\item{font_size_yaxis}{Font size for the y-axis label.}

\item{font_size_yticks}{Font size for the y-axis tick labels.}

\item{format_tooltip}{Tooltip format string, following D3 format specifications.}

\item{y_label}{Label for the y-axis.}

\item{tooltip}{Configuration for tooltips, if specified.}

\item{interval}{Numeric; interval for the plotting, if applicable.}

\item{time_interval}{Time interval for the x-axis, if using time series data.}

\item{colors}{Vector of colors to use for the chart elements.}
}
\value{
A list of configurations for a SveltePlot chart.
}
\description{
Initializes a list of default configuration settings for SveltePlot charts for internal use.
It sets up parameters related to chart dimensions, appearance, axis properties, and more,
to prepare for rendering. This function is not intended for direct use by API consumers.
}
\examples{
\dontrun{
# This function is typically used internally within the SveltePlots package
# and not intended for direct use in scripts or applications.
}
}
\keyword{internal}
