% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spaes.R
\name{spaes}
\alias{spaes}
\title{Create Aesthetic Mappings for SveltePlots}
\usage{
spaes(x, y, ...)
}
\arguments{
\item{x}{The x aesthetic mapping. This could be a column name from the data frame or any expression that evaluates to a numeric or categorical value,
corresponding to the x-axis position of the elements in the plot.}

\item{y}{The y aesthetic mapping. Similarly, this is used for mapping data to the y-axis position in the chart. It can be a direct column reference or
an expression.}

\item{...}{Additional aesthetic mappings. These could include mappings for group, and y_min and y_max for confidence bands.}
}
\value{
An object of class `spaes`, which is a list of unevaluated expressions that define how data is mapped to the visual properties of a chart.
}
\description{
`spaes` creates a list of aesthetic mappings for use with SveltePlot charts. Similar to `aes` in `ggplot2` and `hcaes` in `highcharter`,
it defines how data should be mapped to visual properties such as position, size, and color. `spaes` mappings are used when creating or
adding series to plots, ensuring a consistent and expressive interface for defining the appearance of data in charts.
}
\examples{
library(SveltePlots)

sp(mtcars, spaes(x = disp, y = mpg, group = vs), type = "points")

}
