% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_lineup.R
\name{make_lineup_helper}
\alias{make_lineup_helper}
\title{Determine optimal entries against a given opponent lineup}
\usage{
make_lineup_helper(
  i,
  df_helper,
  op_df_helper,
  end_seq,
  max_ind_entries_helper = 2,
  result_col_helper = result_col
)
}
\arguments{
\item{i}{a sequential list of numbers incremented by 1.  Used to index
function.}

\item{df_helper}{a data frame of times for the team to be entered.  Must
contain column \code{Event} with the same event naming convention as
\code{op_df}, a column with name matching \code{result_col} containing times
or diving scores, and a column called \code{Name} containing athlete names}

\item{op_df_helper}{a data frame containing the opponent lineup.  Must
contain column \code{Event} with the same event naming convention as
\code{df}, a column with name matching \code{result_col} containing times or
diving scores, and a column called \code{Name} containing athlete names}

\item{end_seq}{how many events score}

\item{max_ind_entries_helper}{a numeric value denoting the maximum number of
individual events that may be entered by a single athlete}

\item{result_col_helper}{name of column with results in it}
}
\value{
a data frame containing athletes entered into events
}
\description{
Matches athletes into events.  Each event is filled by the least capable
(slowest) swimmer who can win or place in that event. For example if Team A
has six breaststrokers at 57.00, 58.00, 59.00 and three 1:00.00s and Team B
has three breaststrokers, all 1:01.00 then Team A's entries will be the three
1:00.00s because they're sufficient to win.
}
