% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop_test_b.R
\name{prop_test_b}
\alias{prop_test_b}
\alias{binom_test_b}
\title{Bayesian test of Equal or Given Proportions}
\usage{
prop_test_b(
  n_successes,
  n_failures,
  n_total,
  p,
  predict_for_n,
  ROPE,
  prior = "jeffreys",
  prior_shapes,
  CI_level = 0.95,
  PI_level = 0.95,
  plot = TRUE,
  seed = 1,
  mc_error = 0.002
)
}
\arguments{
\item{n_successes}{integer/numeric vector of length 1 (for 1 population) or
2 (for 2 populations) providing the number of "successes"}

\item{n_failures}{Similar to n_successes, but for failures.  Only provide this
OR n_total.}

\item{n_total}{Similar to n_successes, but for total number of trials.  Only provide this
OR n_failures.}

\item{p}{optional.  If provided and inference is being made for
a single population, \code{prop_test_b} will return the posterior
probability that the population proportion is less than this value.}

\item{predict_for_n}{Number in a future trial.  If missing, \code{prop_test_b}
will use the observed number of trials.}

\item{ROPE}{ROPE for odds ratio if inference is being made for two populations.
Provide either a single value or a vector of length two.  If the former,
the ROPE will be taken as (1/ROPE,ROPE).  If the latter, these will be
the bounds of the ROPE.}

\item{prior}{Either "jeffreys" (Beta(1/2,1/2)) or "uniform" (Beta(1,1)).
This is ignored if prior_shapes is provided.}

\item{prior_shapes}{Vector of length two, giving the shape parameters
for the beta distribution that will act as the prior on the population
proportions.}

\item{CI_level, PI_level}{The posterior probability to be contained in the
credible and prediction intervals respectively.}

\item{plot}{logical.  Should a plot be shown?}

\item{seed}{Always set your seed!  (Unused for a single population proportion.)}

\item{mc_error}{The number of posterior draws will ensure that with 99\%
probability the bounds of the credible intervals of \eqn{p_1 - p_2} will be
within \eqn{\pm} \code{mc_error}. (Ignored for a single population proportion.)}
}
\value{
(returned invisible) A list with the following:
\itemize{
\item \code{successes}, \code{failures}: Number of successes and failures
\item \code{posterior_mean}, \code{posterior_mean_pop1}, \code{posterior_mean_pop2}:
posterior means for the population proportion
\item \code{CI}, \code{CI_pop1}, \code{CI_pop2}: Credible interval for the
population proportion
\item \code{Pr_oddsratio_in_ROPE}: (2 sample analysis only) Posterior
probability that the odds ratio is in the ROPE
\item \code{PI}, \code{PI_pop1}, \code{PI_pop2}: Prediction interval for the
number of trials given in \code{predict_for_n}
\item \code{Pr_less_than_p}: (1 sample analysis only) If \code{p} was
supplied, the posterior probability that the population proportion is less
than \code{p}
\item \code{prop_plot}: Prior and posterior plot of population proportion(s)
\item \code{posterior_parameters}: Posterior beta shape parameters for the
population proportion(s)
}
}
\description{
\code{prop_test_b} either makes inference on a single population
proportion, or else compares two population proportions.
\code{binom_test_b} is the same as \code{prop_test_b}.
}
\details{
The likelihood is given by
\deqn{
 y \sim \text{Binom}(n,p),
}
and the prior on \eqn{p} is
\deqn{
 p \sim Beta(a,b),
}
where \eqn{a} and \eqn{b} are given by the argument \code{prior_shapes}.  If
\code{prior_shapes} is missing and \code{prior = "jeffreys"}, then a
Jeffreys prior will be used (\eqn{Beta(1/2,1/2)}), and if
\code{prior = "uniform"}, then a uniform prior will be used (\eqn{Beta(1,1)}).
}
\examples{
\donttest{
# Single population
prop_test_b(14,
            19)
# or another way of the same thing;
prop_test_b(14,
            n_total = 14 + 19)

# A null value compared against can be added:
prop_test_b(14,
            19,
            p = 0.5)

# Two populations
prop_test_b(c(14,22),
            c(19,45))
# or equivalently
prop_test_b(c(14,22),
            n_total = c(14,22) + c(19,45))
}

}
