% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapse_df_by_group.R
\name{collapse_df_by_group}
\alias{collapse_df_by_group}
\title{Collapse rows by grouping columns}
\usage{
collapse_df_by_group(
  df,
  group_col_names,
  multi_value_col_names = NULL,
  ci_col_names = NULL,
  only_unique_rows = TRUE
)
}
\arguments{
\item{df}{\code{Data frame or tibble} containing the data}

\item{group_col_names}{\code{String vector} containing the column names in \code{df} that serve as grouping columns.}

\item{multi_value_col_names}{\code{String vector} containing the columns names in \code{df} that do not have a unique value (but different values).}

\item{ci_col_names}{\code{String vector} containing the column names in \code{df} that refer to confidence interval bounds (suffix _ci).}

\item{only_unique_rows}{\code{Boolean} that determines if the final data frame or tibble must only keep unique rows}
}
\value{
This function returns a \code{data frame} or \code{tibble} with lower number rows after collapsing
}
\description{
This function paste rows with different values and keep only unique rows following grouping columns
}
\author{
Alberto Castro & Axel Luyten
}
\keyword{internal}
