% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiexpose.R
\name{multiexpose}
\alias{multiexpose}
\title{Aggregate health impacts from multiple exposures}
\usage{
multiexpose(
  output_attribute_exp_1,
  output_attribute_exp_2,
  exp_name_1,
  exp_name_2,
  approach_multiexposure = "additive"
)
}
\arguments{
\item{output_attribute_exp_1, output_attribute_exp_2}{Output of attribute() for exposure 1 and 2, respectively. Baseline health data and population must be identical in outputs 1 and 2.}

\item{exp_name_1, exp_name_2}{\code{String} referring to the name of the environmental exposures 1 and 2}

\item{approach_multiexposure}{\code{String} specifying the multiple exposures approach to be used in the assessment. Options: "additive" (default), "multiplicative" or "combined".}
}
\value{
This function returns a \code{list} containing:

1) \code{health_main} (\code{tibble}) containing the main results;
\itemize{
 \item \code{impact} (\code{numeric} column) attributable health burden/impact
 \item \code{pop_fraction} (\code{numeric} column) population attributable fraction; only applicable in relative risk assessments
 \item And many more
}

2) \code{health_detailed} (\code{list}) containing detailed (and interim) results.
\itemize{
 \item \code{results_raw} (\code{tibble}) containing results for each combination of input uncertainty
 \item \code{results_by_geo_id_micro} (\code{tibble}) containing results for each geographic unit under analysis (specified in \code{geo_id_micro} argument)
 \item \code{input_table} (\code{tibble}) containing the inputs to each relevant argument
 \item \code{input_args} (\code{list}) containing all the argument inputs used in the background
}
}
\description{
This function aggregates health impacts from multiple exposures to environmental stressors.
}
\details{
\strong{Sources}

For more information on the additive and combined approaches see Steenland & Armstrong 2006 (https://doi.org/10.1097/01.ede.0000229155.05644.43).

For more information on the multiplicative approach see Jerrett et al. 2013 (https://doi.org/10.1164/rccm.201303-0609OC).
}
\examples{
# Goal: determine aggregated health impacts from multiple exposures
# Step 1: create assessment with exposure 1
output_attribute_exp_1 <- attribute_health(
  erf_shape = "log_linear",
  rr_central = 1.369,
  rr_increment = 10,
  exp_central = 8.85,
  cutoff_central = 5,
  bhd_central = 30747
)
output_attribute_exp_1$health_main$impact
# Step 2: create assessment with exposure 2
output_attribute_exp_2 <- attribute_mod(
  output_attribute = output_attribute_exp_1,
  exp_central = 10.9,
  rr_central = 1.031
)
output_attribute_exp_2$health_main$impact
# Step 3: aggregate impacts of the two assessments
results <- multiexpose(
  output_attribute_exp_1 = output_attribute_exp_1,
  output_attribute_exp_2 = output_attribute_exp_2,
  exp_name_1 = "pm2.5",
  exp_name_2 = "no2",
  approach_multiexposure = "multiplicative"
)
results$health_main$impact
}
\author{
Alberto Castro & Axel Luyten
}
